/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;

public class ComplexPanel
extends Panel {
    public static final String OPEN_STR = "(";
    public static final String SEPA_STR = "+";
    public static final String CLOSE_STR = "i";
    public static final Font LABEL_FONT = new Font("Courier", 0, 10);
    public static final Font NUMBER_FONT = new Font("Courier", 0, 11);
    public static final Font NUMBER_BOLD_FONT = new Font("Courier", 1, 11);
    public static final String FIELD_FORM_STR = "%+05.2f";
    protected boolean isEditable = true;
    protected Format fieldFormat = new Format("%+05.2f");
    protected Label open;
    protected Label sepa;
    protected Label close;
    protected TextField reF;
    protected TextField imF;
    protected double oldRe;
    protected double oldIm;

    ComplexPanel() {
        this(new ALMA_Complex());
    }

    ComplexPanel(ALMA_Complex aLMA_Complex) {
        this(new ALMA_Complex(), true);
    }

    ComplexPanel(ALMA_Complex aLMA_Complex, boolean bl, Color color) {
        this(aLMA_Complex, bl);
        if (bl) {
            this.reF.setForeground(color);
            this.imF.setForeground(color);
            return;
        }
        this.reF.setForeground(color);
        this.imF.setForeground(color);
        ((Component)this.reF).setBackground(Defs.greyColour);
        ((Component)this.imF).setBackground(Defs.greyColour);
    }

    ComplexPanel(ALMA_Complex aLMA_Complex, boolean bl) {
        System.out.println(this.getClass().getName());
        this.setLayout(new FlowLayout(1, 0, 0));
        this.open = new Label(OPEN_STR);
        this.close = new Label(CLOSE_STR);
        this.open.setFont(LABEL_FONT);
        this.close.setFont(LABEL_FONT);
        this.open.setAlignment(1);
        this.close.setAlignment(1);
        this.reF = new TextField();
        this.imF = new TextField();
        this.isEditable = bl;
        this.set(aLMA_Complex);
        if (bl) {
            this.reF.setFont(NUMBER_FONT);
            this.imF.setFont(NUMBER_FONT);
        } else {
            this.reF.setEditable(false);
            this.imF.setEditable(false);
            this.reF.setFont(NUMBER_BOLD_FONT);
            this.imF.setFont(NUMBER_BOLD_FONT);
        }
        ((Component)this.reF).setBackground(Color.white);
        ((Component)this.imF).setBackground(Color.white);
        this.add(this.reF);
        this.add(this.imF);
        this.add(this.close);
    }

    public void set(ALMA_Complex aLMA_Complex) {
        if (!aLMA_Complex.isInfinite() && !aLMA_Complex.isNaN()) {
            this.oldRe = aLMA_Complex.re();
            this.oldIm = aLMA_Complex.im();
            ((TextComponent)this.reF).setText(this.fieldFormat.form(aLMA_Complex.re()));
            ((TextComponent)this.imF).setText(this.fieldFormat.form(aLMA_Complex.im()));
        }
    }

    public ALMA_Complex get() {
        double d;
        double d2;
        try {
            d2 = new Double(this.reF.getText());
            d = new Double(this.imF.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.set(new ALMA_Complex(this.oldRe, this.oldIm));
            d2 = this.oldRe;
            d = this.oldIm;
        }
        return new ALMA_Complex(d2, d);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof TextField) {
            event.target = this;
            event.arg = this.get();
            return super.handleEvent(event);
        }
        return false;
    }

    public String toString() {
        return "ComplexLabel[" + this.reF + " " + this.imF + CLOSE_STR + "]";
    }

    public static void main(String[] stringArray) {
    }
}

