/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

public class VectorLine
extends LineSegment {
    protected boolean is_alive;
    protected boolean is_visible;
    protected Color live_color;
    protected Color dead_color;
    protected VectorArrow arrowhead;
    protected String name;
    protected double Theta;
    protected double Magnitude;
    protected double X;
    protected double Y;

    VectorLine() {
        System.out.println(this.getClass().getName());
        this.live_color = Color.black;
        this.is_alive = false;
        this.is_visible = true;
        this.arrowhead = new VectorArrow();
        this.name = "";
        this.Theta = 0.0;
        this.Magnitude = 0.0;
        this.Y = 0.0;
        this.X = 0.0;
    }

    VectorLine(int n, int n2, int n3, int n4, Color color) {
        super.set(n, n2, n3, n4, color);
        System.out.println(this.getClass().getName());
        this.arrowhead.set(n, n2, n3, n4);
    }

    VectorLine(int n, int n2, int n3, int n4) {
        super.set(n, n2, n3, n4);
        System.out.println(this.getClass().getName());
        this.arrowhead.set(n, n2, n3, n4);
    }

    public void make_alive() {
        this.dead_color = this.getColor();
        this.is_alive = true;
        this.setColor(this.live_color);
    }

    public void make_dead() {
        if (this.is_alive) {
            this.setColor(this.dead_color);
            this.is_alive = false;
        }
    }

    public boolean isVisible() {
        return this.is_visible;
    }

    public void visibility(boolean bl) {
        this.is_visible = bl;
    }

    public void set(int n, int n2, int n3, int n4) {
        if (this.is_visible) {
            super.set(n, n2, n3, n4);
            this.arrowhead.set(n, n2, n3, n4);
        }
    }

    public void setMagnitudeTheta(int n) {
        this.X = (double)(this.x2 - this.x1) / (double)n;
        this.Y = (double)(this.y1 - this.y2) / (double)n;
        this.Magnitude = Math.sqrt(this.X * this.X + this.Y * this.Y);
        this.Theta = Math.atan(Math.abs(this.Y / this.X)) * 180.0 / Math.PI;
        if (this.Y < 0.0) {
            if (this.X >= 0.0) {
                this.Theta = -this.Theta;
                return;
            }
            this.Theta -= 180.0;
            return;
        }
        if (this.X < 0.0) {
            this.Theta = 180.0 - this.Theta;
        }
    }

    public double getTheta() {
        return this.Theta;
    }

    public double getMagnitude() {
        return this.Magnitude;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void drawThick(Graphics graphics) {
        if (this.is_visible) {
            int n = -1;
            while (n <= 1) {
                int n2 = -1;
                while (n2 <= 1) {
                    graphics.drawLine(this.x1 + n, this.y1 + n2, this.x2 + n, this.y2 + n2);
                    ++n2;
                }
                ++n;
            }
            this.arrowhead.drawThick(graphics);
        }
    }

    public void draw(Graphics graphics) {
        if (this.is_visible) {
            graphics.drawLine(this.x1, this.y1, this.x2, this.y2);
            this.arrowhead.draw(graphics);
        }
    }
}

