(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17656,        431]
NotebookOptionsPosition[     16460,        387]
NotebookOutlinePosition[     16897,        404]
CellTagsIndexPosition[     16854,        401]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Installing the FractalGeometry packages", "Title",
 CellChangeTimes->{{3.460203633378354*^9, 3.4602036417143*^9}}],

Cell[TextData[{
 "I\[CloseCurlyQuote]ve written a couple of packages to make it easy to \
explore self-similar and related sets in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ".  "
}], "Text",
 CellChangeTimes->{3.643875333972048*^9}],

Cell[TextData[{
 "These ",
 StyleBox["FractalGeometry", "Input"],
 " packages have been tested with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " versions 9 and 10 and should run with versions 7 and 8 as well.  They can \
be downloaded in one collection from my website:\n",
 ButtonBox["http://marksmath.org/Mathematica/FractalGeometryPackages.zip",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://marksmath.org/Mathematica/FractalGeometryPackages.zip"], None},
  ButtonNote->
   "http://marksmath.org/Mathematica/FractalGeometryPackages.zip"],
 "."
}], "Text",
 CellChangeTimes->{{3.459795242455844*^9, 3.4597952964914494`*^9}, {
  3.460203576217597*^9, 3.460203592392528*^9}, {3.460203622965386*^9, 
  3.4602036286103153`*^9}, {3.460203675317114*^9, 3.4602036796679277`*^9}, {
  3.4602061717959223`*^9, 3.460206234306252*^9}, {3.6438748500729647`*^9, 
  3.64387496755595*^9}, {3.6438752689885883`*^9, 3.64387532890432*^9}}],

Cell["\<\
This file should unzip to a folder called FractalGeometryPackages containing \
several items.  The sub-folder named FractalGeometry contains the actual \
packages.  There are also several notebooks describing the basic use of the \
packages.  This notebook describes installation.\
\>", "Text",
 CellChangeTimes->{{3.460203726276923*^9, 3.4602038253203487`*^9}, {
   3.4602041336899776`*^9, 3.460204143910363*^9}, 3.4602048797808027`*^9, {
   3.643874913298369*^9, 3.643874918832675*^9}}],

Cell[CellGroupData[{

Cell["Quick start", "Subsection",
 CellChangeTimes->{{3.460204154433354*^9, 3.460204158614807*^9}, {
  3.460204911127163*^9, 3.460204914163473*^9}, {3.643875054336524*^9, 
  3.643875057495824*^9}}],

Cell["\<\
If you just want to experiment with the pacakge a bit, you can leave the \
directory structure as originally unzipped and execute the following command.\
\
\>", "Text",
 CellChangeTimes->{{3.4602042000620737`*^9, 3.460204221206614*^9}, {
  3.4602044141439238`*^9, 3.4602044351663647`*^9}, {3.46020492093557*^9, 
  3.460204944036895*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrependTo", "[", 
   RowBox[{"$Path", ",", " ", 
    RowBox[{"NotebookDirectory", "[", "]"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.459795341946485*^9, 3.459795353972837*^9}, 
   3.459938984087975*^9, {3.460204469978207*^9, 3.460204500130416*^9}, {
   3.460204552465988*^9, 3.4602045530730743`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Permanent installation", "Subsection",
 CellChangeTimes->{{3.460204600594891*^9, 3.460204605800249*^9}}],

Cell[TextData[{
 "If you plan to use the ",
 StyleBox["FractalGeometry", "Input"],
 " packages a lot, you might install them where ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can always find them.  To do so, simply drop the FractalGeometry \
sub-folder into some directory on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s search path.  This is specified by the global variable ",
 StyleBox["$Path", "Input"],
 ". An ideal location is the value of the global variable ",
 StyleBox["$UserAddOnsDirectory", "Input"],
 ". On my Mac, I get the following:"
}], "Text",
 CellChangeTimes->{{3.459938810883739*^9, 3.459938905100355*^9}, {
  3.460204624058831*^9, 3.460204808512398*^9}, {3.46020488206039*^9, 
  3.460204886252606*^9}}],

Cell[CellGroupData[{

Cell[BoxData["$UserAddOnsDirectory"], "Input",
 CellChangeTimes->{{3.459938794555789*^9, 3.459938802194353*^9}}],

Cell[BoxData["\<\"/Users/mcmcclur/Library/Mathematica\"\>"], "Output",
 CellChangeTimes->{3.459938802937902*^9, 3.459961714662547*^9, 
  3.460241613597148*^9, 3.6438750138431377`*^9}]
}, Open  ]],

Cell[TextData[{
 "Now any of the ",
 StyleBox["Needs", "Input"],
 " commands described in the other tutorials should work from any notebook on \
your system."
}], "Text",
 CellChangeTimes->{{3.4602048215878983`*^9, 3.460204856409177*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking", "Subsection",
 CellChangeTimes->{{3.643875181085471*^9, 3.643875182988392*^9}}],

Cell[TextData[{
 "In either case, the ",
 StyleBox["Needs", "Input"],
 " command should now find the packages.  For example:"
}], "Text",
 CellChangeTimes->{{3.460204533063137*^9, 3.4602045920076838`*^9}, {
  3.643875040602178*^9, 3.6438750482161303`*^9}, {3.643875080496526*^9, 
  3.643875105670467*^9}, {3.643875187253663*^9, 3.6438751914285192`*^9}}],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FractalGeometry`IteratedFunctionSystems`\>\"", 
  "]"}]], "Input"],

Cell["So the following should produce a Sierpinski triangle.", "Text",
 CellChangeTimes->{{3.643875154180965*^9, 3.643875154316971*^9}, {
  3.6438751972359056`*^9, 3.643875211427657*^9}, {3.643875955378118*^9, 
  3.643875958575007*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"M", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"1", "/", "2"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gasketIFS", " ", "=", " ", 
   RowBox[{"{", "\n", "\t", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"M", ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0"}], "}"}]}], "}"}], ",", " ", "\n", "\t", 
     RowBox[{"{", 
      RowBox[{"M", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", " ", "0"}], "}"}]}], "}"}], ",", " ", 
     "\n", "\t", 
     RowBox[{"{", 
      RowBox[{"M", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "4"}], ",", " ", 
         RowBox[{
          RowBox[{"Sqrt", "[", "3", "]"}], "/", "4"}]}], "}"}]}], "}"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ShowIFS", "[", 
  RowBox[{"gasketIFS", ",", " ", "7"}], "]"}]}], "Input",
 CellChangeTimes->{{3.4602269463844976`*^9, 3.46022694667828*^9}, {
  3.643875124782514*^9, 3.643875159838048*^9}}],

Cell[BoxData[
 GraphicsBox[PointBox[CompressedData["
1:eJxtnX2MpWdZxpsK0hgqglb5sHgU8CuhBGKCNcTzWkAFCmpbCZKoBxQMUWkx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   "]],
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  CoordinatesToolOptions:>Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellChangeTimes->{{3.643875115098827*^9, 3.6438751609229803`*^9}, 
   3.643875960918192*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1194, 684},
WindowMargins->{{Automatic, 47}, {Automatic, 50}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"10.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (September 9, \
2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 120, 1, 92, "Title"],
Cell[690, 25, 243, 7, 30, "Text"],
Cell[936, 34, 944, 20, 69, "Text"],
Cell[1883, 56, 498, 8, 49, "Text"],
Cell[CellGroupData[{
Cell[2406, 68, 197, 3, 44, "Subsection"],
Cell[2606, 73, 347, 7, 30, "Text"],
Cell[2956, 82, 344, 7, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3337, 94, 110, 1, 44, "Subsection"],
Cell[3450, 97, 747, 18, 71, "Text"],
Cell[CellGroupData[{
Cell[4222, 119, 112, 1, 28, "Input"],
Cell[4337, 122, 183, 2, 28, "Output"]
}, Open  ]],
Cell[4535, 127, 238, 6, 31, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4810, 138, 96, 1, 44, "Subsection"],
Cell[4909, 141, 353, 7, 31, "Text"],
Cell[5265, 150, 108, 2, 28, "Input"],
Cell[5376, 154, 236, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[5637, 161, 1220, 37, 131, "Input"],
Cell[6860, 200, 9560, 182, 328, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
